document.addEventListener('DOMContentLoaded', function () {

    function refreshList() {
        var auctionListElements = document.querySelectorAll('.auction-list');
        auctionListElements.forEach(function (element) {

            var currencySymbol = element.getAttribute('data-currency-symbol');
            var entryId = element.getAttribute('data-entry-id');

            $.ajax({
                type: 'POST',
                data: {'entry_id': entryId, 'currency': currencySymbol},
                async: false,
                url: '/handle/list-bids?limit=2',
                success: function (response) {
                    element.innerHTML = response;
                },
                error: function (xhr) {
                    $.each(xhr.responseJSON.message, function (i, field) {
                        $.each(field, function (i, message) {
                            Toast.fire(message, 'error');
                        });
                    });
                }
            })
        });
    }

    function updateCountdown() {
        var countdownElements = document.querySelectorAll('.auction-countdown');

        countdownElements.forEach(function (element) {
            var timestamp = element.getAttribute('data-timestamp');

            if (timestamp.length === 13) {
                timestamp = timestamp.substring(0, 10);
            }

            timestamp = parseInt(timestamp, 10);

            var now = new Date().getTime();
            var timeRemaining = timestamp * 1000 - now;

            var days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));
            var hours = Math.floor((timeRemaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

            var countdownText = countdownAuctionOptions.remainingTime + ' ' + days + ' ' + countdownAuctionOptions.days + ' ' + hours + ':' + minutes + ':' + seconds;

            element.innerHTML = countdownText;
        });
    }

    updateCountdown();
    refreshList();

    setInterval(function () {
        updateCountdown()
        refreshList()
    }, 1000);
});