<?php namespace Visiosoft\BiddingModule\Scale\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ScaleTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'lower_scale' => [
            'value' => "{{currency_format(entry.lower_scale,setting_value('streams::currency'))}}"
        ],
        'upper_scale' => [
            'value' => "{{currency_format(entry.upper_scale,setting_value('streams::currency'))}}"
        ],
        'amount_of_increase',
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'amount_of_increase' => 'ASC'
        ],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
