<?php namespace Visiosoft\BiddingModule\Offer;

use Visiosoft\BiddingModule\Offer\Contract\OfferInterface;
use Anomaly\Streams\Platform\Model\Bidding\BiddingOffersEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OfferModel extends BiddingOffersEntryModel implements OfferInterface
{
    use HasFactory;

    /**
     * @return OfferFactory
     */
    protected static function newFactory()
    {
        return OfferFactory::new();
    }

    protected $appends = [
        'approvable'
    ];

    public function getApprovableAttribute()
    {
        if ($this->parent_adv_id) {

            $approved = $this->newQuery()
                ->where('parent_adv_id', $this->parent_adv_id)
                ->where('status', true)
                ->first();

            return !$approved;
        }
        return false;
    }
}
