<?php namespace Visiosoft\BiddingModule\Offer\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;

class OfferFormHandler
{
    public function handle(
        OfferFormBuilder $builder,
        AdvRepositoryInterface $advRepository,
        MessageBag $message,
        Currency $currency,
        ScaleRepositoryInterface $scaleRepository,
        OfferRepositoryInterface $repository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $entry_id = $builder->getEntry();

        if ($entry_id) {
            $adv = $advRepository->find($entry_id);
        }
        if ((auth()->user() and auth()->user()->hasRole('admin')) or
            ($adv && ((!$adv->expired() && $adv->getStatus() === 'approved') ||
                    $adv->created_by_id === \auth()->id()))) {

            $amount_entered = $builder->getPostValue('bid_price');

            $scale_entry = $scaleRepository->findBetweenScale($amount_entered);

            $bid_price = ($scale_entry) ? round($amount_entered / $scale_entry->amount_of_increase) * $scale_entry->amount_of_increase : $amount_entered;

            $last_offer_price = $adv->standard_price;

            if ($last_offer = $repository->getLastOfferByAd($adv->id)) {
                $last_offer_price = $last_offer->bid_price;
            }

            if ($bid_price <= $last_offer_price) {
                $message->error(["Lütfen önceki tekliften daha yüksek bir teklif giriniz."]);
                return;

            }

            if ($bid_price != $amount_entered) {
                $message->info(['Teklifiniz artış baremleri gereğince ' . $currency->format($bid_price, $adv->currency) . ' olarak ayarlandı!']);
            }

            $entry = $repository->newCreate([
                'parent_adv' => $adv,
                'bid_price' => $bid_price,
                'str_id' => str_random(24)
            ]);

            $message->success(['Teklifiniz başarıyla alındı!']);

            event(new NewOfferSubmitted($entry));

        } else {
            $message->error(trans('visiosoft.module.advs::message.ad_doesnt_exist'));
            return;
        }

    }
}
