<?php namespace Visiosoft\BiddingModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\BiddingModule\Scale\Form\ScaleFormBuilder;
use Visiosoft\BiddingModule\Scale\ScaleRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingScaleEntryModel;
use Visiosoft\BiddingModule\Scale\ScaleModel;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Form\OfferFormBuilder;
use Visiosoft\BiddingModule\Offer\OfferRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingOffersEntryModel;
use Visiosoft\BiddingModule\Offer\OfferModel;
use Illuminate\Routing\Router;

class BiddingModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        BiddingModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/bidding/scale' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ScaleController@index',
        'admin/bidding/scale/create' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ScaleController@create',
        'admin/bidding/scale/edit/{id}' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ScaleController@edit',
        'admin/bidding' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@index',
        'admin/bidding/create' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@create',
        'admin/bidding/edit/{id}' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@edit',

        // Teklif Verme Sayfası
        'ad/{slug}/{id}/give-offer' => [
            'as' => 'visiosoft.module.bidding::give_offer',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@giveOffer',
        ],

        // Ajax
        'bidding/index/{id}' => 'Visiosoft\BiddingModule\Http\Controller\AjaxController@index',
        'bidding/add-item/{id}' => 'Visiosoft\BiddingModule\Http\Controller\AjaxController@addItem',

        // Profile Routes
        'profile/bidding/incoming-offers' => [
            'as' => 'visiosoft.module.bidding::profile.incoming_offers',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@incomingOffers',
        ],
        'profile/bidding/my-offers' => [
            'as' => 'visiosoft.module.bidding::profile.my_offers',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@myOffers',
        ],
        'profile/bidding/bids-i-won' => [
            'as' => 'visiosoft.module.bidding::profile.my_offers',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@bidsIWon',
        ],

        // Approve Incoming Offer
        'profile/bidding/approve-incoming-offer/{str_id}' => [
            'as' => 'visiosoft.module.bidding::action.approve_incoming_offer',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@approveIncomingOffer',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BiddingModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BiddingModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\BiddingModule\Event\ExampleEvent::class => [
        //    Visiosoft\BiddingModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BiddingModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BiddingScaleEntryModel::class => ScaleModel::class,
        'offer_form' => OfferFormBuilder::class,
        'scale_form' => ScaleFormBuilder::class,
        BiddingOffersEntryModel::class => OfferModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ScaleRepositoryInterface::class => ScaleRepository::class,
        OfferRepositoryInterface::class => OfferRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

    public function boot(AddonCollection $addonCollection)
    {
        $settings_url = [
            'bidding_settings' => [
                'title' => 'visiosoft.module.bidding::button.bidding_settings',
                'href' => '/admin/settings/modules/visiosoft.module.bidding',
                'page' => 'visiosoft.module.bidding'
            ],
        ];

        foreach ($settings_url as $key => $value) {
            $addonCollection->get($value['page'])->addSection($key, $value);
        }
    }


}
