<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBiddingCreateOffersStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'offers',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'parent_adv' => [
            'required' => true,
        ],
        'bid_price' => [
            'required' => true,
        ],
        'str_id',
        'order_item_id',
        'status'
    ];

}
