<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\AdvsModule\Adv\AdvModel;

class VisiosoftModuleBiddingCreateBiddingFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'parent_adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'lookup',
                'related' => AdvModel::class,
            ],
        ],
        'bid_price' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'decimal' => 2,
                'separator' => '.',
                'point' => ','
            ],
        ],
        'str_id' => 'anomaly.field_type.text',
        'order_item_id' => 'anomaly.field_type.integer',
        'status' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        'lower_scale' => [
            'type' => 'anomaly.field_type.decimal',
            "config" => [
                "separator" => ".",
                "point" => ",",
                "decimals" => 2,
            ]
        ],
        'upper_scale' => [
            'type' => 'anomaly.field_type.decimal',
            "config" => [
                "separator" => ".",
                "point" => ",",
                "decimals" => 2,
            ]
        ],
        'amount_of_increase' => 'anomaly.field_type.integer',
    ];

}
