<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;

class ValidOfferChanged
{
    private $provisionRepository;
    private $offerRepository;
    
    public function __construct(ProvisionRepository $provisionRepository,
    OfferRepositoryInterface $offerRepository
    )
    {
        $this->provisionRepository = $provisionRepository;
        $this->offerRepository = $offerRepository;
    }

    public function handleValidOfferChange(NewOfferSubmitted $entry)
    {
        $offer = $entry->getOffer();

        // Let's first find the previous highest offer (offer with the status 'approvable') for this product.
        $relatedAdvId = $offer->parent_adv_id;
        $invalidOffer = $this->offerRepository->newQuery()->
        where('id', '!=', $offer->id)->
        where('parent_adv_id', $relatedAdvId)->
        where('approvable', true)->first();

        if (is_null($invalidOffer)) {
            return;
        }

        // Now, let's make the status of the provision 'free', whose related offer is this invalid offer and whose status is 'linked'
        $provisionToMakeFree = $this->provisionRepository->newQuery()->
        where('offer_of_provision_id', '!=', $invalidOffer->id)->
        where('status_of_provision', 'linked')->
        first();

        $provisionToMakeFree->update([
            'status_of_provision' => 'free',
        ]);
    }
}