<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\BiddingModule\Offer\Events\OfferApproved;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Carbon\Carbon;
use Visiosoft\BiddingModule\Provision\Command\CheckAndTakeActionIfPriceWasNotSent;

class ValidOfferApproved
{
    private $provisionRepository;
    private $offerRepository;

    use DispatchesJobs;
    
    public function __construct(ProvisionRepository $provisionRepository,
    OfferRepositoryInterface $offerRepository
    )
    {
        $this->provisionRepository = $provisionRepository;
        $this->offerRepository = $offerRepository;
    }

    public function handleValidOfferApprove(OfferApproved $entry)
    {
        // 7 günlük süre içerisinde bu teklife bağlı ürünün satışı gerçekleşirse bu teklifin bağlı olduğu
        // provizyonlardan statüsü bağlı olanın statüsünü 'free' yap
        // satış bu süre zarfında gerçekleşmezse provizyon statüsünü 'registedAsRevenue' yap
        $this->dispatch(new CheckAndTakeActionIfPriceWasNotSent($entry))->delay(now()->addDays(7));
    }
}