<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;

class ListenIyzicoPaymentCreate
{
    private $advRepository;
    private $message;
    private $provisionRepository;
    private $orderdetailRepository;
    private $customFieldRepository;
    private $customFieldAdvRepository;
    
    public function __construct(AdvRepositoryInterface $advRepository, 
    ProvisionRepository $provisionRepository,
    OrderdetailRepositoryInterface $orderdetailRepository,
    CustomFieldRepositoryInterface $customFieldRepository,
    CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
    MessageBag $message
    )
    {
        $this->advRepository = $advRepository;
        $this->message = $message;
        $this->provisionRepository = $provisionRepository;
        $this->orderdetailRepository = $orderdetailRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->customFieldAdvRepository = $customFieldAdvRepository;
    }

    public function handle(IyziciPaymentCreated $event)
    {

        $payment = $event->getThreedsPayment();
        $items = $payment->getPaymentItems();

        foreach ($items as $item)
        {
            $orderId = $item->getItemId();

            $orderDetail = $this->orderdetailRepository->findBy('sort_order', $orderId);

            // dd($orderId, $orderDetail);
     
            $provisionAdv = $this->advRepository->findBy('slug', 'provision');
     
            if ($orderDetail->item_id == $provisionAdv->id) {
                $paymentTransactionIdCustomField = $this->customFieldRepository->findBy('slug', 'payment_transaction_id');
                $this->customFieldAdvRepository->create([
                    'parent_adv' => $provisionAdv,
                    'custom_field_category' => $paymentTransactionIdCustomField,
                    'custom_field_value' => $item->getPaymentTransactionId(),
                    'custom_field_type' => 'integer',
                ]);
            }
        }
    }
}