<?php namespace Visiosoft\BiddingModule\Provision\Command;

use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;

class CheckAndTakeActionIfPriceWasNotSent
{
    protected $offer;
    protected $orderdetailRepository;
    protected $provisionRepository;

    public function __construct($offer, OrderdetailRepositoryInterface $orderdetailRepository, ProvisionRepositoryInterface $provisionRepository)
    {
        $this->offer = $offer;
        $this->orderdetailRepository = $orderdetailRepository;
        $this->provisionRepository = $provisionRepository;
    }

    public function handle(OfferRepositoryInterface $repository)
    {
        $provisionToMakeFree = $this->provisionRepository->newQuery()->
        where('offer_of_provision_id', $this->offer->id)->
        where('status_of_provision', 'linked')->
        first(); 

        if ($orderDetail->status === 'awaiting_payment') {
            $provisionToMakeFree->update([
                'status_of_provision' => 'registedAsRevenue',
            ]);
        } else {
            $provisionToMakeFree->update([
                'status_of_provision' => 'free',
            ]);            
        }
    }
}
