<?php namespace Visiosoft\BiddingModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;

class ProvisionController extends PublicController
{
    protected $provisionRepository;

    public function __construct(
        ProvisionRepositoryInterface $provisionRepository)
    {
        $this->provisionRepository = $provisionRepository;
        parent::__construct();
    }

    public function changeStatusToRequsted($id)
    {
        $requestedProvision = $this->provisionRepository->find($id);
        $requestedProvision->update([
            'status_of_provision' => 'requstedBack',
        ]);

        $this->messages->success(trans('visiosoft.module.bidding::field.request_received'));

        return redirect()->route('visiosoft.module.bidding::profile.my_provisions');
    }
}
