<?php namespace Visiosoft\BiddingModule\Scale;

use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ScaleRepository extends EntryRepository implements ScaleRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ScaleModel
     */
    protected $model;

    /**
     * Create a new ScaleRepository instance.
     *
     * @param ScaleModel $model
     */
    public function __construct(ScaleModel $model)
    {
        $this->model = $model;
    }

    public function findBetweenScale($price)
    {
        return $this->newQuery()
            ->whereRaw('? between lower_scale and upper_scale', [$price])
            ->first();
    }
}
