<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BiddingModule\Offer\Command\RemoveApprovableAnotherOffers;
use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;

class ListenIyzicoPaymentCreate
{
    private $advRepository;
    private $message;
    private $redirect;
    private $provisionRepository;
    private $orderdetailRepository;
    private $customFieldRepository;
    private $customFieldAdvRepository;
    private $scaleRepository;
    private $offerRepository;
    
    public function __construct(AdvRepositoryInterface $advRepository, 
    ProvisionRepository $provisionRepository,
    OrderdetailRepositoryInterface $orderdetailRepository,
    CustomFieldRepositoryInterface $customFieldRepository,
    CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
    OfferRepositoryInterface $offerRepository,
    ScaleRepositoryInterface $scaleRepository,
    MessageBag $message
    )
    {
        $this->advRepository = $advRepository;
        $this->message = $message;
        $this->provisionRepository = $provisionRepository;
        $this->orderdetailRepository = $orderdetailRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->offerRepository = $offerRepository;
        $this->customFieldAdvRepository = $customFieldAdvRepository;
        $this->scaleRepository = $scaleRepository;
    }

    use DispatchesJobs;

    public function handle(IyziciPaymentCreated $event)
    {
        $payment = $event->getThreedsPayment();
        $items = $payment->getPaymentItems();

        foreach ($items as $item)
        {
            $orderDetailId = $item->getItemId();

            $orderDetail = $this->orderdetailRepository->find($orderDetailId);

            if ($orderDetail->item_type == 'provision') {
                $provisionJustBought = $this->provisionRepository->find($orderDetail->item_id);
                $provisionJustBought->update([
                    'paymentTransactionId' => $item->getPaymentTransactionId(),
                ]);

                $relatedAdv = $provisionJustBought->related_adv;
                $offerPrice = $provisionJustBought->offer_price;

                $previousLinkedProvision = $this->provisionRepository->newQuery()->
                where('related_adv_id', $relatedAdv->id)->where('provision_status', 'linked')->first();

                if (!is_null($previousLinkedProvision)) {
                    $previousLinkedProvision->update([
                        'provision_status' => 'free',
                        'related_adv' => null,
                        'offer_price' => null,
                        'offer_of_provision_id' => null,
                    ]);            
                }

                $provisionJustBought->update([
                    'provision_status' => 'linked',        
                ]);

                // save offer

                $scale_entry = $this->scaleRepository->findBetweenScale($offerPrice);

                $bid_price = ($scale_entry) ? floor($offerPrice / $scale_entry->amount_of_increase) * $scale_entry->amount_of_increase : $offerPrice;
        
                $last_offer_price = $relatedAdv->standard_price;
        
                if ($last_offer = $this->offerRepository->getLastOfferByAd($relatedAdv->id)) {
                    $last_offer_price = $last_offer->bid_price;
                }
        
                if ($bid_price <= $last_offer_price) {
                    $this->message->error(trans('visiosoft.module.bidding::message.higher_offer_previous_offer'));
                    return;
                }

                $entry = $this->offerRepository->newCreate([
                    'parent_adv' => $relatedAdv,
                    'bid_price' => $bid_price,
                    'str_id' => str_random(24),
                    'approvable' => true,
                ]);

                // update the status of other offers
                $this->dispatch(new RemoveApprovableAnotherOffers($entry));   
                
                // Update the linked provision that has been just created 
                $provisionJustBought->update([
                    'offer_of_provision_id' => $entry->id,
                ]);     
                
                $this->message->success(trans('visiosoft.module.bidding::message.success_offer'));
                $this->message->success(trans('visiosoft.module.carts::message.payment_approved'));

                event(new NewOfferSubmitted($entry));

                abort( redirect(route('visiosoft.module.bidding::profile.my_offers')) );
            }
        }
    }
}