$(document).ready(function () {
    toggleScaleButton($('select[name="cf__is_made_bid"]'))
});

$('select[name="cf__is_made_bid"]').on('change', function () {
    let element = $(this);
    toggleScaleButton(element);
});

function toggleScaleButton(element) {
    if (element.val() == is_made_bid_customfields_value) {
        $('.custom-fields[data-slug="is_made_bid"]').after(`
            <div class="col-md-3 form-group custom-fields justify-content-between d-flex align-items-center select_container mx-0 my-4" 
            data-slug="is_made_bid-action">
                <button type="button" class="btn btn-default change-bid-charts-btn mt-4"
                  data-toggle="modal" data-target="#bid-charts-modal">
                    <i class="fas fa-pencil-alt mr-2"></i>
                    Baremleri Düzenle
                </button>
            </div>
        `);
    } else {
        $('.custom-fields[data-slug="is_made_bid-action"]').remove();
    }
}

$('#bid-charts-modal').on('shown.bs.modal', function (e) {
    scaleAction.load();
});


function addScaleItem() {
    let scale_index_length = $('#bid-charts-modal .bid-chart-items .scale-item').length;
    scaleAction.add(scale_index_length + 1);
};

function deleteScaleItem(index) {
    scaleAction.remove(index);
};

function submitScale() {
    let form = $('form[name="scale-form"]');

    console.log(form.serializeArray())

}


let scaleAction = {
    add: function (index) {
        $('#bid-charts-modal .bid-chart-items').find('.remove-scale-btn').addClass('d-none');
        this.request('/bidding/add-item/' + index, '', 'GET', function (data) {
            $('#bid-charts-modal .bid-chart-items').append(data);
        });
        syncDecimalsField()
    },
    remove: function (index) {
        $('#bid-charts-modal .modal-content').find('.scale-item[data-id="' + index + '"]').remove();
        $('#bid-charts-modal .bid-chart-items').find('.remove-scale-btn[data-id="' + (index - 1) + '"]').removeClass('d-none');
    },
    save: function () {
        this.request()
    },
    request: function (url, params, method, callback) {
        // loading.show();
        crudAjax(params, url, method, function (data) {
            callback(data);
        }, true).then(function () {
            // loading.hide();
        })
    },
    load: function () {
        this.request('/bidding/index/' + bidding_options.entry_id, '', 'GET', function (data) {
            $('#bid-charts-modal .modal-content').html(data);
        })
    }
}

function syncDecimalsField() {
    let fields = Array.prototype.slice.call(
        document.querySelectorAll('input[data-provides="anomaly.field_type.decimal"]')
    );

    fields.forEach(function (field) {

        field.addEventListener('change', function (event) {

            if (event.target.value == '') {
                return;
            }

            event.target.value = Number(event.target.value).toFixed(event.target.dataset.decimals);
        });
    });
}

$('input[data-provides="anomaly.field_type.decimal"]').on('click mouseleave', function (e) {

    let element = $(this);

    if (e.type == "click") {
        if (element.val() == "0.00") {
            element.val("");
        }
    } else {
        if (element.val() == "") {
            element.val("0.00");
        }
    }

});
