<?php namespace Visiosoft\BiddingModule\Scale;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;

class ScaleSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        $repository = app(ScaleRepositoryInterface::class);

        $default_bidding_scale = array(
            array('lower_scale' => '25000.00', 'upper_scale' => '50000.00', 'amount_of_increase' => '500'),
            array('lower_scale' => '0.00', 'upper_scale' => '5000.00', 'amount_of_increase' => '100'),
            array('lower_scale' => '100000.00', 'upper_scale' => '250000.00', 'amount_of_increase' => '2500'),
            array('lower_scale' => '50000.00', 'upper_scale' => '100000.00', 'amount_of_increase' => '1000'),
            array('lower_scale' => '250000.00', 'upper_scale' => '500000.00', 'amount_of_increase' => '5000'),
            array('lower_scale' => '5000.00', 'upper_scale' => '25000.00', 'amount_of_increase' => '250'),
            array('lower_scale' => '500000.00', 'upper_scale' => '1000000.00', 'amount_of_increase' => '10000'),
            array('lower_scale' => '1000000.00', 'upper_scale' => '2500000.00', 'amount_of_increase' => '25000'),
            array('lower_scale' => '2500000.00', 'upper_scale' => '5000000.00', 'amount_of_increase' => '50000'),
            array('lower_scale' => '5000000.00', 'upper_scale' => '10000000.00', 'amount_of_increase' => '100000')
        );

        foreach ($default_bidding_scale as $scale) {
            $repository->newQuery()->create($scale);
        }
    }
}
