<?php namespace Visiosoft\BiddingModule\Seeders;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class CustomFieldsSeeder extends Seeder
{

    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customfield_value_repository = app(CfvalueRepositoryInterface::class);

            if (!$customFieldRepository->findBySlug('is_made_bid')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'is_made_bid',
                        'name' => 'Teklif Verilebilir mi',
                        'type' => 'select',
                        'required' => true
                    ]
                );

                $cf_values = [
                    [
                        'custom_field_value' => 'No',
                        'custom_field_id' => $customfield->getId(),
                    ],
                    [
                        'custom_field_value' => 'Yes',
                        'custom_field_id' => $customfield->getId(),
                    ]
                ];

                foreach ($cf_values as $cf_value) {
                    $customfield_value_repository->newQuery()->create($cf_value);
                }
            }

            if (!$customFieldRepository->findBySlug('offer_price')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'offer_price',
                        'name' => 'Offer Price',
                        'type' => 'integer',
                    ]
                );
            }

            if (!$customFieldRepository->findBySlug('related_Adv_Id')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'related_Adv_Id',
                        'name' => 'Related Adv Id',
                        'type' => 'integer',
                    ]
                );
            }
            
            if (!$customFieldRepository->findBySlug('buy_now_price')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'buy_now_price',
                        'name' => 'Buy Now Price',
                        'type' => 'integer',
                    ]
                );
            }

            if (!$customFieldRepository->findBySlug('payment_transaction_id')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'payment_transaction_id',
                        'name' => 'Payment Transaction Id',
                        'type' => 'integer',
                    ]
                );
            }

        }
    }

}
