<?php namespace Visiosoft\BiddingModule\Provision;

use Illuminate\Support\Facades\Auth;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ProvisionRepository extends EntryRepository implements ProvisionRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ProvisionModel
     */
    protected $model;

    /**
     * Create a new ProvisionRepository instance.
     *
     * @param ProvisionModel $model
     */
    public function __construct(ProvisionModel $model)
    {
        $this->model = $model;
    }

    public function getFreePrevision()
    {
        return $this->newQuery()
        ->where('user_of_provision_id', auth()->id())
        ->where('status_of_provision', 'free')
        ->get();
    }

    public function myProvisions()
    {
        return $this
            ->newQuery()->where('created_by_id', Auth::id())
            ->orderByDesc('created_at')
            ->paginate(setting_value('streams::per_page'));
    }
}
