<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\BiddingModule\Offer\Events\OfferExpired;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;

class ValidOfferExpired
{
    private $provisionRepository;
    private $offerRepository;
    
    public function __construct(ProvisionRepository $provisionRepository,
    OfferRepositoryInterface $offerRepository
    )
    {
        $this->provisionRepository = $provisionRepository;
        $this->offerRepository = $offerRepository;
    }

    public function handleValidOfferExpire(OfferExpired $entry)
    {
        // let's make the status of the provision 'free', whose related offer is this expired offer and whose status is 'linked'
        $provisionToMakeFree = $this->provisionRepository->newQuery()->
        where('offer_of_provision_id', $entry->id)->
        where('status_of_provision', 'linked')->
        first();

        $provisionToMakeFree->update([
            'status_of_provision' => 'free',
        ]);
    }
}