<?php namespace Visiosoft\BiddingModule\Provision\Listener;

use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Command\RemoveApprovableAnotherOffers;
use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;
use Illuminate\Foundation\Bus\DispatchesJobs;

class SaveProvision
{
    private $advRepository;
    private $customFieldAdvRepository;
    private $customFieldRepository;
    private $redirect;
    private $scaleRepository;
    private $offerRepository;
    private $message;
    private $provisionRepository;
    
    public function __construct(AdvRepositoryInterface $advRepository, 
    CustomFieldRepositoryInterface $customFieldRepository, 
    ScaleRepositoryInterface $scaleRepository,
    OfferRepositoryInterface $offerRepository,
    ProvisionRepository $provisionRepository,
    MessageBag $message,
    CustomFieldAdvRepositoryInterface $customFieldAdvRepository)
    {
        $this->advRepository = $advRepository;
        $this->customFieldAdvRepository = $customFieldAdvRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->scaleRepository = $scaleRepository;
        $this->offerRepository = $offerRepository;
        $this->message = $message;
        $this->provisionRepository = $provisionRepository;
    }

    use DispatchesJobs;

    public function handlePaymentSuccess(PaymentSuccess $order)
    {
        $orderDetail = $order->getOrderDetail();

        if ($orderDetail[0]->item_type != 'adv') {
            return;
        } 

        $orderedAdv = $this->advRepository->find($orderDetail[0]->item_id);

        // Any product can be sold but we are only listening to the 'provision product' being sold. 

        if ($orderedAdv->slug == 'provision') {
            // The provision has been sold. 

            $provisions = app(ProvisionRepository::class);

            // get provision adv's custom feature values (like offer price, related adv) that are related to last offer

            $provisionAdv = $this->advRepository->findBy('slug', 'provision');

            $offerPriceCustomField = $this->customFieldRepository->findBy('slug', 'offer_price');
            $recordContainOfferPrice = $this->customFieldAdvRepository->newQuery()->where('parent_adv_id', $provisionAdv->id)
            ->where('custom_field_category_id', $offerPriceCustomField->id)->first();
            $offerPrice = $recordContainOfferPrice->custom_field_value;

            $paymentTransactionIdCustomField = $this->customFieldRepository->findBy('slug', 'payment_transaction_id');
            $recordContainPaymentTransactionId = $this->customFieldAdvRepository->newQuery()->where('parent_adv_id', $provisionAdv->id)
            ->where('custom_field_category_id', $paymentTransactionIdCustomField->id)->first();
            $paymentTransactionId = $recordContainPaymentTransactionId->custom_field_value;

            $relatedAdvIdCustomField = $this->customFieldRepository->findBy('slug', 'related_adv_id');
            $recordContainRelatedAdvId = $this->customFieldAdvRepository->newQuery()->where('parent_adv_id', $provisionAdv->id)
            ->where('custom_field_category_id', $relatedAdvIdCustomField->id)->first();
            $relatedAdv = $this->advRepository->newQuery()->where('advs_advs.id', $recordContainRelatedAdvId->custom_field_value)->first();            

            $offerIdsMadeForOrderedAdv = $this->offerRepository->newQuery()->
            where('parent_adv_id', $relatedAdv->id)->
            pluck('id')->all();

            // dd($offerIdsMadeForOrderedAdv);

            if (count($offerIdsMadeForOrderedAdv) > 0) {
                $linkedProvision = $this->provisionRepository->newQuery()->
                whereIn('offer_of_provision_id', $offerIdsMadeForOrderedAdv)->
                where('status_of_provision', 'linked')->first();

                if (!is_null($linkedProvision)) {
                    $linkedProvision->update([
                        'status_of_provision' => 'free'
                    ]);
                }
            }

            // Now let's save the related information to the provision stream

            $provisionJustBought = $provisions->create([
                'amount_of_provision' => $orderedAdv->price,
                'status_of_provision' => 'linked',        
                'return_time_of_provision' => null,
                'description_of_provision' => null,
                'user_of_provision_id' => auth()->id(),
                'offer_of_provision_id' => null,   
                'paymentTransactionId' => $paymentTransactionId,    
            ]);

            // save offer

            $scale_entry = $this->scaleRepository->findBetweenScale($offerPrice);

            $bid_price = ($scale_entry) ? floor($offerPrice / $scale_entry->amount_of_increase) * $scale_entry->amount_of_increase : $offerPrice;
    
            $last_offer_price = $relatedAdv->standard_price;
    
            if ($last_offer = $this->offerRepository->getLastOfferByAd($relatedAdv->id)) {
                $last_offer_price = $last_offer->bid_price;
            }
    
            if ($bid_price <= $last_offer_price) {
                $this->message->error(trans('visiosoft.module.bidding::message.higher_offer_previous_offer'));
                return;
            }
    
            $entry = $this->offerRepository->newCreate([
                'parent_adv' => $relatedAdv,
                'bid_price' => $bid_price,
                'str_id' => str_random(24),
                'approvable' => true,
            ]);

            // update the status of other offers
            $this->dispatch(new RemoveApprovableAnotherOffers($entry));
        
            // Update the linked provision that has been just created 
            $provisionJustBought->update([
                'offer_of_provision_id' => $entry->id,
            ]);
    
            // delete the 'provision prodcuts's custom features 
            $recordContainOfferPrice->delete();
            $recordContainRelatedAdvId->delete();
            $recordContainPaymentTransactionId->delete();
            $buyNowPriceCustomField = $this->customFieldRepository->findBy('slug', 'buy_now_price');
            $recordContainBuyNowPrice = $this->customFieldAdvRepository->newQuery()->where('parent_adv_id', $provisionAdv->id)
            ->where('custom_field_category_id', $buyNowPriceCustomField->id)->first();
            $recordContainBuyNowPrice->delete();

            $this->message->success(trans('visiosoft.module.bidding::message.success_offer'));
            $this->message->success(trans('visiosoft.module.carts::message.payment_approved'));

            event(new NewOfferSubmitted($entry));

            abort( redirect(route('visiosoft.module.bidding::profile.my_offers')) );

        } else {
            // This is heavy-machine
            // Now that the money transfer is done, we can set the provision status of this adv to 'free'.
            $relatedOffer = $offerRepository->newQuery()->where('parent_adv_id', $orderedAdv->id)->
            where('approvable', true)->first();

            $provisionToMakeFree = $this->provisionRepository->newQuery()->
            where('offer_of_provision_id', $relatedOffer->id)->
            where('status_of_provision', 'linked')->
            first();
    
            $provisionToMakeFree->update([
                'status_of_provision' => 'free',
            ]);
        }
    }
}