<?php namespace Visiosoft\BiddingModule\Offer\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\BiddingModule\Offer\Command\RemoveApprovableAnotherOffers;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Illuminate\Routing\Redirector;
use Symfony\Component\HttpFoundation\Response;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class OfferFormHandler 
{
    use DispatchesJobs;

    public function handle(
        OfferFormBuilder $builder,
        AdvRepositoryInterface $advRepository,
        MessageBag $message,
        ScaleRepositoryInterface $scaleRepository,
        ProvisionRepositoryInterface $provisionRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        Redirector $redirect,
        Response $response,
        OfferRepositoryInterface $repository)
    {
        // First let's detect if the user has an free provision that can be linked with offer/product 
        $freePrevision = $provisionRepository->getFreePrevision();
        if (count($freePrevision) === 0) {
            // The user does not have a free provision. 
            // So we will redirect the user to the 'buying provision' page with appropriate message 
            $message->warning(trans('visiosoft.module.bidding::message.buyProvision'));
            $adv = $advRepository->find($builder->getEntry());
            $provisionAdv = $advRepository->findBy('slug', 'provision');
            $offerPriceCustomField = $customFieldRepository->findBy('slug', 'offer_price');
            $customFieldAdvRepository->create([
                'parent_adv' => $provisionAdv,
                'custom_field_category' => $offerPriceCustomField,
                'custom_field_value' => $builder->getPostValue('bid_price'),
                'custom_field_type' => 'integer',
            ]);
            $relatedAdvIdCustomField = $customFieldRepository->findBy('slug', 'related_adv_id');
            $customFieldAdvRepository->create([
                'parent_adv' => $provisionAdv,
                'custom_field_category' => $relatedAdvIdCustomField,
                'custom_field_value' => $builder->getEntry(),
                'custom_field_type' => 'integer',
            ]);
            $buyNowPriceCustomField = $customFieldRepository->findBy('slug', 'buy_now_price');
            $customFieldAdvRepository->create([
                'parent_adv' => $provisionAdv,
                'custom_field_category' => $buyNowPriceCustomField,
                'custom_field_value' => $adv->price,
                'custom_field_type' => 'integer',
            ]);
            $builder->setFormResponse($redirect->route('adv_detail', ['id' => $provisionAdv->id]));
            return;
        }

        // The user has a free provision. So we can continue to save the offer that the user has sent.

        if (!$builder->canSave()) {
            return;
        }

        $entry_id = $builder->getEntry();

        if ($entry_id) {
            $adv = $advRepository->find($entry_id);
        }
        if ((auth()->user() and auth()->user()->hasRole('admin')) or
            ($adv && ((!$adv->expired() && $adv->getStatus() === 'approved') ||
                    $adv->created_by_id === \auth()->id()))) {

            $amount_entered = $builder->getPostValue('bid_price');

            $scale_entry = $scaleRepository->findBetweenScale($amount_entered);

            $bid_price = ($scale_entry) ? floor($amount_entered / $scale_entry->amount_of_increase) * $scale_entry->amount_of_increase : $amount_entered;

            $last_offer_price = $adv->standard_price;

            if ($last_offer = $repository->getLastOfferByAd($adv->id)) {
                $last_offer_price = $last_offer->bid_price;
            }

            if ($bid_price <= $last_offer_price) {
                $message->error(trans('visiosoft.module.bidding::message.higher_offer_previous_offer'));
                return;

            }

            $entry = $repository->newCreate([
                'parent_adv' => $adv,
                'bid_price' => $bid_price,
                'str_id' => str_random(24),
                'approvable' => true,
            ]);

            // update the status of other offers
            $this->dispatch(new RemoveApprovableAnotherOffers($entry));

            $offerIdsMadeForOrderedAdv = $repository->newQuery()->
            where('parent_adv_id', $adv->id)
            ->pluck('id')->all();

            if (count($offerIdsMadeForOrderedAdv) > 0) {
                $linkedProvision = $provisionRepository->newQuery()->
                whereIn('offer_of_provision_id', $offerIdsMadeForOrderedAdv)->
                where('status_of_provision', 'linked')->first();

                if (!is_null($linkedProvision)) {
                    $linkedProvision->update([
                        'status_of_provision' => 'free'
                    ]);
                }
            }

            // Update the first created provision whose status is 'free' and which is belong to the user. 
            $provisionAdv = $advRepository->findBy('slug', 'provision');
            $freeProvisionRepositories = $provisionRepository->newQuery()->where('status_of_provision', 'free')->
            where('user_of_provision_id', auth()->user()->id)->orderBy('created_at', 'asc');
            $freeProvisionRepositories->first()->update([
                'amount_of_provision' => $provisionAdv->price,
                'status_of_provision' => 'linked',
                'user_of_provision_id' => auth()->user()->id,
                'offer_of_provision_id' => $entry->id,
            ]);

            $message->success(trans('visiosoft.module.bidding::message.success_offer'));

            event(new NewOfferSubmitted($entry));

        } else {
            $message->error(trans('visiosoft.module.advs::message.ad_doesnt_exist'));
            return;
        }
    }
}
