<?php namespace Visiosoft\BiddingModule\Http\Controller\Admin;

use Visiosoft\BiddingModule\Provision\Form\ProvisionFormBuilder;
use Visiosoft\BiddingModule\Provision\Table\ProvisionTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Request;
use Anomaly\Streams\Platform\Message\MessageBag;

class ProvisionsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ProvisionTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ProvisionTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ProvisionFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ProvisionFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ProvisionFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ProvisionFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function returnProvision($id)
    {
        $provisionThatWillBeRefunded = app(ProvisionRepositoryInterface::class)->find($id);

        $options = new \Iyzipay\Options();
        $options->setApiKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl(setting_value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));

        $request = new \Iyzipay\Request\CreateRefundRequest();
        $request->setLocale(setting_value('streams::default_locale'));
        $request->setPaymentTransactionId($provisionThatWillBeRefunded->paymentTransactionId);
        $request->setPrice($provisionThatWillBeRefunded->amount_of_provision);
        $request->setCurrency(setting_value('streams::currency'));
        $request->setIp(Request::ip());
        
        $refund = \Iyzipay\Model\Refund::create($request, $options);  

        if ($refund->getStatus() == 'success') {
            $provisionThatWillBeRefunded->update([
                'status_of_provision' => 'returned'
            ]);

            $this->messages->success(trans('module::message.refund_successfull'));

            return redirect()->back();
        } else {
            $this->messages->error(trans('module::message.refund_error'));
            return redirect()->back();
        }
    }
}
