<?php namespace Visiosoft\BiddingModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BiddingModule\Provision\Listener\ListenIyzicoPaymentCreate;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\BiddingModule\Scale\Form\ScaleFormBuilder;
use Visiosoft\BiddingModule\Scale\ScaleRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingScaleEntryModel;
use Visiosoft\BiddingModule\Scale\ScaleModel;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Form\OfferFormBuilder;
use Visiosoft\BiddingModule\Offer\OfferRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingOffersEntryModel;
use Visiosoft\BiddingModule\Offer\OfferModel;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\CustomFieldAdvRepository;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldRepository;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\BiddingModule\Offer\Events\NewOfferSubmitted;
use Visiosoft\BiddingModule\Offer\Events\OfferExpired;
use Visiosoft\BiddingModule\Offer\Events\OfferApproved;
use Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated;

class BiddingModuleServiceProvider extends AddonServiceProvider
{

    protected $plugins = [
        BiddingModulePlugin::class,
    ];

    protected $routes = [
        'admin/bidding/scale' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ScaleController@index',
        'admin/bidding/scale/create' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ScaleController@create',
        'admin/bidding/scale/edit/{id}' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ScaleController@edit',
        'admin/bidding' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@index',
        'admin/bidding/create' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@create',
        'admin/bidding/edit/{id}' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@edit',

        // Teklif Verme Sayfası
        'ad/{slug}/{id}/give-offer' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::give_offer',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@giveOffer',
        ],

        // Profile Routes
        'profile/bidding/incoming-offers' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::profile.incoming_offers',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@incomingOffers',
        ],
        'profile/bidding/my-offers' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::profile.my_offers',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@myOffers',
        ],
        'profile/bidding/my-provisions' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::profile.my_provisions',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@myProvisions',
        ],
        'profile/bidding/i-won' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::profile.i_won',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@iWon',
        ],

        // Save offer
        'offer/bidding/save/{offerPrice}/{relatedAdv}' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::order.save',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@saveOrder',            
        ],

        // recall Request
        'provision/recall/{id}' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::provision.recall',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProvisionController@changeStatusToRequsted',            
        ],

        // return
        'provision/return/{id}' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::provision.return',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ProvisionsController@returnProvision',               
        ],

        // Approve Incoming Offer
        'profile/bidding/approve-incoming-offer/{str_id}' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.bidding::action.approve_incoming_offer',
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@approveIncomingOffer',
        ],

        // CRON
        'cron/incoming-offers' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@cronLastIncomingOffer',
    ];

    protected $listeners = [
        PaymentSuccess::class => [
            '\Visiosoft\BiddingModule\Provision\Listener\SaveProvision@handlePaymentSuccess',
        ],
        OfferExpired::class => [
            '\Visiosoft\BiddingModule\Provision\Listener\ValidOfferExpired@handleValidOfferExpire',
        ],
        OfferApproved::class => [
            '\Visiosoft\BiddingModule\Provision\Listener\ValidOfferApproved@handleValidOfferApprove',
        ],
        IyziciPaymentCreated::class => [
            ListenIyzicoPaymentCreate::class,
        ],
    ];

    protected $bindings = [
        BiddingScaleEntryModel::class => ScaleModel::class,
        'offer_form' => OfferFormBuilder::class,
        'scale_form' => ScaleFormBuilder::class,
        BiddingOffersEntryModel::class => OfferModel::class,
    ];

    protected $singletons = [
        ScaleRepositoryInterface::class => ScaleRepository::class,
        OfferRepositoryInterface::class => OfferRepository::class,
        ProvisionRepositoryInterface::class => ProvisionRepository::class,
        CustomFieldAdvRepositoryInterface::class => CustomFieldAdvRepository::class,
        CustomFieldRepositoryInterface::class => CustomFieldRepository::class,
    ];

    public function boot(AddonCollection $addonCollection)
    {
        $settings_url = [
            'bidding_settings' => [
                'title' => 'visiosoft.module.bidding::button.bidding_settings',
                'href' => '/admin/settings/modules/visiosoft.module.bidding',
                'page' => 'visiosoft.module.bidding'
            ],
        ];

        foreach ($settings_url as $key => $value) {
            $addonCollection->get($value['page'])->addSection($key, $value);
        }
    }
}
