<?php namespace Visiosoft\BiddingModule\Scale\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class ScaleTableBuilder extends TableBuilder
{
    protected $columns = [
        'lower_scale' => [
            'value' => "{{currency_format(entry.lower_scale,setting_value('streams::currency'))}}"
        ],
        'upper_scale' => [
            'value' => "{{currency_format(entry.upper_scale,setting_value('streams::currency'))}}"
        ],
        'amount_of_increase',
    ];

    protected $buttons = [
        'edit'
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [
        'order_by' => [
            'amount_of_increase' => 'ASC'
        ],
    ];
}
