<?php namespace Visiosoft\BiddingModule\Offer;

use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OfferRepository extends EntryRepository implements OfferRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OfferModel
     */
    protected $model;

    /**
     * Create a new OfferRepository instance.
     *
     * @param OfferModel $model
     */
    public function __construct(OfferModel $model)
    {
        $this->model = $model;
    }

    public function appendBid($entry_id, $price)
    {
        $entry = $this->getModel();
        $entry->setAttribute('parent_adv_id',$entry_id);
        $entry->setAttribute('bid_price',$price);
        $entry->save();

        return $entry;
    }
}
