<?php namespace Visiosoft\BiddingModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Visiosoft\BiddingModule\AdDetail\Contract\AdDetailRepositoryInterface;
use Visiosoft\BiddingModule\AdDetail\AdDetailRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingAdDetailEntryModel;
use Visiosoft\BiddingModule\AdDetail\AdDetailModel;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Bidding\BiddingProvisionsEntryModel;
use Anomaly\Streams\Platform\Ui\Form\Event\FormWasPosted;
use Visiosoft\BiddingModule\Listeners\SaveBidEntryForAdvs;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\OfferRepository;
use Anomaly\Streams\Platform\Model\Bidding\BiddingOffersEntryModel;
use Visiosoft\BiddingModule\Offer\OfferModel;
use Visiosoft\BiddingModule\Provision\Contract\ProvisionRepositoryInterface;
use Visiosoft\BiddingModule\Provision\ProvisionModel;
use Visiosoft\BiddingModule\Provision\ProvisionRepository;
use Visiosoft\BiddingModule\Offer\Events\OfferExpired;

class BiddingModuleServiceProvider extends AddonServiceProvider
{

    protected $plugins = [
        BiddingModulePlugin::class,
    ];

    protected $routes = [
        'handle/append-bid' => [
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\AuctionController@appendBid',
            'middleware' => 'auth',
            'verb' => 'POST'
        ],
        'handle/list-bids' => [
            'uses' => 'Visiosoft\BiddingModule\Http\Controller\AuctionController@bids',
            'middleware' => 'auth',
            'verb' => 'POST'
        ],



//        'admin/bidding' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@index',
//        'admin/bidding/create' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@create',
//        'admin/bidding/edit/{id}' => 'Visiosoft\BiddingModule\Http\Controller\Admin\OffersController@edit',
//        'admin/bidding/provisions' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ProvisionsController@index',
//
//        // Teklif Verme Sayfası
//        'ad/{slug}/{id}/give-offer' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::give_offer',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@giveOffer',
//        ],
//
//        // Profile Routes
//        'profile/bidding/incoming-offers' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::profile.incoming_offers',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@incomingOffers',
//        ],
//        'profile/bidding/my-offers' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::profile.my_offers',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@myOffers',
//        ],
//        'profile/bidding/my-provisions' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::profile.my_provisions',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@myProvisions',
//        ],
//        'profile/bidding/i-won' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::profile.i_won',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProfileController@iWon',
//        ],
//
//        // Save offer
//        'offer/bidding/save/{offerPrice}/{relatedAdv}' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::order.save',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@saveOrder',
//        ],
//
//        // recall Request
//        'provision/recall/{id}' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::provision.recall',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProvisionController@changeStatusToRequsted',
//        ],
//
//        // return
//        'provision/return/{id}' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::provision.return',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\Admin\ProvisionsController@returnProvision',
//        ],
//
//        // Approve Incoming Offer
//        'profile/bidding/approve-incoming-offer/{str_id}' => [
//            'middleware' => 'auth',
//            'as' => 'visiosoft.module.bidding::action.approve_incoming_offer',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@approveIncomingOffer',
//        ],
//
//        'provision/buy/{advIdToBeOffered}/{offerPrice}/{buyNowPrice}' => [
//            'middleware' => 'auth',
//            'as' => 'provision:buy',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProvisionController@buyProvision',
//        ],
//
//        'provision/prepareToAddToCart' => [
//            'middleware' => 'auth',
//            'as' => 'provision:prepareToAddToCart',
//            'uses' => 'Visiosoft\BiddingModule\Http\Controller\ProvisionController@prepareToAddToCart',
//        ],
//
//        // CRON
//        'cron/incoming-offers' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@cronLastIncomingOffer',
//
//        'cron/check-if-approved-offers-was-paid' => 'Visiosoft\BiddingModule\Http\Controller\OffersController@checkPayment',
    ];

    protected $listeners = [
        OfferExpired::class => [
            '\Visiosoft\BiddingModule\Provision\Listener\ValidOfferExpired@handleValidOfferExpire',
        ],
        FormWasPosted::class => [
            SaveBidEntryForAdvs::class
        ],
    ];

    protected $bindings = [
        BiddingAdDetailEntryModel::class => AdDetailModel::class,
        BiddingOffersEntryModel::class => OfferModel::class,
        BiddingProvisionsEntryModel::class => ProvisionModel::class,
    ];

    protected $singletons = [
        AdDetailRepositoryInterface::class => AdDetailRepository::class,
        OfferRepositoryInterface::class => OfferRepository::class,
        ProvisionRepositoryInterface::class => ProvisionRepository::class,
    ];

    protected $overrides = [
        'visiosoft.module.advs::new-ad/price-area' => 'visiosoft.module.bidding::addons/visiosoft/advs-module/new-ad/price-area',
    ];

    public function boot(AddonCollection $addonCollection)
    {
        $settings_url = [
            'bidding_settings' => [
                'title' => 'visiosoft.module.bidding::button.bidding_settings',
                'href' => '/admin/settings/modules/visiosoft.module.bidding',
                'page' => 'visiosoft.module.bidding'
            ],
        ];

        foreach ($settings_url as $key => $value) {
            $addonCollection->get($value['page'])->addSection($key, $value);
        }
    }
}
