<?php namespace Visiosoft\BiddingModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\BiddingModule\AdDetail\Contract\AdDetailRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;

class BiddingModulePlugin extends Plugin
{
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getEntryDetail',
                function ($ad_id) {
                    $repository = app(AdDetailRepositoryInterface::class);

                    return $repository->findByEntryID($ad_id);
                }
            )
        ];
    }
}
