<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBiddingCreateAdDetailStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'ad_detail',
        'title_column' => 'entry_id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'entry' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\AdvsModule\Adv\AdvModel::class,
                'mode' => 'lookup'
            ],
        ],
        'buy_it_now_price' => 'visiosoft.field_type.decimal',
        'currency' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'currencies',
            ],
        ],
        'auction_duration' => 'anomaly.field_type.integer',
        'starting_bid_price' => 'visiosoft.field_type.decimal',
        'reserve_price' => 'visiosoft.field_type.decimal',
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'entry' => [
            'required' => true,
        ],
        'buy_it_now_price' => [
            'required' => true,
        ],
        'currency' => [
            'required' => true,
        ],
        'auction_duration' => [
            'required' => true,
        ],
        'starting_bid_price' => [
            'required' => true,
        ],
        'reserve_price',
    ];

}
