<?php namespace Visiosoft\BiddingModule\Offer;

use Illuminate\Support\Facades\Auth;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OfferRepository extends EntryRepository implements OfferRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OfferModel
     */
    protected $model;

    /**
     * Create a new OfferRepository instance.
     *
     * @param OfferModel $model
     */
    public function __construct(OfferModel $model)
    {
        $this->model = $model;
    }

    public function newCreate(array $params)
    {
        return $this->newQuery()->create($params);
    }

    public function getLastOfferByAd($ad_id)
    {
        return $this->newQuery()
            ->where('parent_adv_id', $ad_id)
            ->orderByDesc('id')
            ->first();
    }

    public function getByAds(array $id_list)
    {
        return $this->newQuery()->whereIn('parent_adv_id', $id_list)
            ->orderByDesc('id')
            ->paginate(setting_value('streams::per_page'));
    }

    public function myOffers()
    {
        return $this
            ->newQuery()->where('created_by_id', Auth::id())
            ->orderByDesc('created_at')
            ->paginate(setting_value('streams::per_page'));
    }

    public function iWon()
    {
        return $this
            ->newQuery()->where('created_by_id', Auth::id())
            ->orderByDesc('created_at')
            ->where('status', true)
            ->paginate(setting_value('streams::per_page'));
    }

    public function removeApprovableAnotherOffers($offer_id,$parent_adv_id)
    {
        return $this->newQuery()
            ->where('id', '!=', $offer_id)
            ->where('parent_adv_id', $parent_adv_id)
            ->update([
                'approvable' => false,
            ]);
    }
}
