<?php namespace Visiosoft\BiddingModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class ProfileController extends PublicController
{
    protected $advRepository;
    protected $customFieldRepository;
    protected $repository;

    public function __construct(AdvRepositoryInterface $advRepository, OfferRepositoryInterface $repository, CustomFieldRepositoryInterface $customFieldRepository)
    {
        $this->advRepository = $advRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->repository = $repository;
        parent::__construct();
    }

    public function incomingOffers()
    {
        $my_ads = $this->customFieldRepository
            ->QueryAdsWithCFValue('is_made_bid', setting_value('visiosoft.module.bidding::is_made_bid_customfields_value'))
            ->get()->pluck('id')->all();

        $offers = $this->repository->getByAds($my_ads);

        return $this->view->make('visiosoft.module.bidding::incoming-offers', compact('offers'));
    }

    public function myOffers()
    {
        $my_offers = $this->repository->myOffers();

        return $this->view->make('visiosoft.module.bidding::my-offers', compact('my_offers'));
    }

    public function iWon()
    {
        $i_won = $this->repository->iWon();

        return $this->view->make('visiosoft.module.bidding::offers-i-won', compact('i_won'));
    }
}
