<?php namespace Visiosoft\BiddingModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Carbon\Carbon;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\BiddingModule\Offer\Events\OfferApproved;
use Visiosoft\BiddingModule\Offer\Events\OfferExpired;
use Visiosoft\BiddingModule\Scale\Contract\ScaleRepositoryInterface;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;

class OffersController extends PublicController
{
    protected $advRepository;
    protected $orderRepository;
    protected $orderdetailModel;
    protected $scaleRepository;
    protected $repository;

    public function __construct(
        AdvRepositoryInterface $advRepository,
        OrderRepositoryInterface $orderRepository,
        OrderdetailModel $orderdetailModel,
        ScaleRepositoryInterface $scaleRepository,
        OfferRepositoryInterface $repository)
    {
        $this->advRepository = $advRepository;
        $this->orderRepository = $orderRepository;
        $this->orderdetailModel = $orderdetailModel;
        $this->scaleRepository = $scaleRepository;
        $this->repository = $repository;
        parent::__construct();
    }

    public function giveOffer($slug, $id)
    {
        if ($id) {
            $adv = $this->advRepository->findByIDAndSlug($id, $slug);
        } else {
            $id = $slug;
            $adv = $this->advRepository->getListItemAdv($id);
        }

        if ((auth()->user() and auth()->user()->hasRole('admin')) or
            ($adv && ((!$adv->expired() && $adv->getStatus() === 'approved') ||
                    $adv->created_by_id === \auth()->id()))) {

            $last_offer = $this->repository->getLastOfferByAd($id);

            $last_price = ($last_offer) ? $last_offer->bid_price : $adv->standard_price;

            $scale_entry = $this->scaleRepository->findBetweenScale($last_price);

            return $this->view->make('visiosoft.module.bidding::give-offer', compact('adv', 'scale_entry'));

        } else {
            $this->messages->error(trans('visiosoft.module.advs::message.ad_doesnt_exist'));
            return redirect()->route('visiosoft.module.advs::list');
        }
    }

    public function approveIncomingOffer($str_id)
    {
        $offer = $this->repository->findBy('str_id', $str_id);

        if ($offer->approvable) {

            // Create Order
            $order_item_id = $this->soldAd($offer->parent_adv_id, $offer);

            $offer->setAttribute('order_item_id', $order_item_id);
            $offer->setAttribute('status', true);
            $offer->save();

            event(new OfferApproved($offer));

            $this->messages->success(['Teklif onaylandı!']);
            return $this->redirect->route('orders::sale_detail', ['id' => $order_item_id]);

        } else {
            $this->messages->error(['Zaten onaylanmış bir teklif bulunmaktadır!']);
            return $this->redirect->route('visiosoft.module.bidding::profile.incoming_offers');
        }

    }

    public function soldAd($id, $offer)
    {

        if ($adv = $this->advRepository->find($id)) {
            $adv->setAttribute('is_get_adv', true);
            $adv->setAttribute('stock', 0);
            $adv->save();
        }

        $shipping = setting_value('visiosoft.module.orders::shipping');
        $tax = setting_value('visiosoft.module.orders::tax');
        $currency = ($offer->parent_adv->currency) ? $offer->parent_adv->currency : setting_value('streams::currency');

        // Calculate Total
        $total = $shipping +
            $tax +
            $offer->bid_price;

        // Create Order
        $order_id = $this->orderRepository->newQuery()
            ->create([
                'user' => $offer->created_by,
                'pay_type' => 'order',
                'total' => $total,
                'type' => 'adv',
                'subtotal' => $offer->bid_price,
                'shipping' => $shipping,
                'tax' => $tax,
                'currency' => $currency,
                'status' => 'pending',
                'order_at' => date('Y-m-d H:i:s'),
            ]);

        // Create Detail
        $order_detail_params = [
            'item_id' => $id,
            'item_type' => 'adv',
            'price' => $offer->bid_price,
            'currency' => $currency,
            'piece' => 1,
            'total' => $offer->bid_price,
            'order' => $order_id,
            'status' => 'awaiting_payment',
        ];

        return $this->orderdetailModel->create_datail($order_detail_params);
    }


    public function cronLastIncomingOffer()
    {
        $date = Carbon::now();

        $date->addDays('-2');

        $entries = $this->repository->newQuery()
//            ->whereDate('created_at', '<', $date->format('Y-m-d H:i:s'))
            ->where('approvable', true)
            ->where('timeout_notice', false)
            ->limit(10)
            ->get();

        foreach ($entries as $entry) {
            try {
                event(new OfferExpired($entry));
                echo $entry->id;

                $entry->setAttribute('timeout_notice', true);
                $entry->save();

            } catch (\Exception $exception) {
                echo $exception->getMessage();
            }
        }
    }
}
