<?php

return [
    'is_made_bid_customfields_value' => [
        'type' => 'anomaly.field_type.select',
        'bind' => 'bidding.is_made_bid_customfields_value',
        'config' => [
            'options' => function (\Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface $customFieldRepository,
                                   \Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface $cfvalueRepository) {
                if ($customfield = $customFieldRepository->findBySlug('is_made_bid')) {
                    return $cfvalueRepository->newQuery()->where('custom_field_id',$customfield->getId())
                        ->get()
                        ->pluck('custom_field_value', 'id')
                        ->all();
                }
                return [];
            },
        ],
    ],
    'proposal_agreement' => [
        'bind' => 'bidding.proposal_agreement',
        'type' => 'anomaly.field_type.wysiwyg',
        'config' => [
            'height' => 500,
        ],
    ],

];