<?php namespace Visiosoft\BasicCheckoutExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;

class BasicCheckoutController extends PublicController
{
    private $orderdetailRepository;
    private $orderRepository;
    private $adv_model;
    private $addressRepository;

    public function __construct(
        AdvModel $advModel,
        OrderdetailRepositoryInterface $orderdetailRepository,
        AdressRepositoryInterface $addressRepository,
        OrderRepositoryInterface $orderRepository)
    {
        parent::__construct();
        $this->adv_model = $advModel;
        $this->orderRepository = $orderRepository;
        $this->addressRepository = $addressRepository;
        $this->orderdetailRepository = $orderdetailRepository;
    }


    public function fast_checkout($id)
    {
        if ($adv = $this->checkBuyable($id)) {
            Cookie::queue(Cookie::make('fast-checkout-entry-id', $adv->getId(), 84000));
            return $this->view->make('visiosoft.extension.basic_checkout::checkout', compact('adv'));
        }
        abort(404);
    }

    public function payment()
    {
        if ($entry_id = $this->request->cookie('fast-checkout-entry-id') and $adv = $this->checkBuyable($entry_id)) {


            $user = Auth::user();

            //Save Address
            $first_name = $this->request->adress_first_name;
            $last_name = $this->request->adress_last_name;
            $country_id = $this->request->country;
            $city_id = $this->request->city;
            $content = $this->request->adress_content;
            $gsm_phone = $this->request->adress_gsm_phone;

            $address = $this->addressRepository->createAddress('My Address', $user->getId(), $first_name, $last_name, $country_id, $city_id, $content, $gsm_phone);
            $country = $address->getCountry()->getTitle();
            $city = $address->getCity()->getTitle();

            //Create Order
            $order = $this->createOrder($adv->getId(), $adv->price, $address->getId(), $address->getId());

            $expiration = explode('/', $this->request->expiration);

            $options = new \Iyzipay\Options();
            $options->setApiKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
            $options->setSecretKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
            $options->setBaseUrl(setting_value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));

            $request = new \Iyzipay\Request\CreatePaymentRequest();
            $request->setLocale(setting_value('streams::default_locale'));
            $request->setPrice($adv->price);
            $request->setConversationId($order->getId());
            $request->setPaidPrice($adv->price);
            $request->setCurrency(setting_value('streams::currency'));
            $request->setInstallment(1);
            $request->setCallbackUrl(route('visiosoft.extension.basic_checkout::fast-checkout.result'));

            $paymentCard = new \Iyzipay\Model\PaymentCard();
            $paymentCard->setCardHolderName($this->request->name);
            $paymentCard->setCardNumber(str_replace(' ', '', $this->request->ccno));
            $paymentCard->setExpireMonth(array_first($expiration));
            $paymentCard->setExpireYear(end($expiration));
            $paymentCard->setCvc($this->request->ccv);
            $paymentCard->setRegisterCard(0);
            $request->setPaymentCard($paymentCard);

            $buyer = new \Iyzipay\Model\Buyer();
            $buyer->setId(Auth::id());
            $buyer->setName($address->adress_first_name);
            $buyer->setSurname($address->adress_last_name);
            $buyer->setEmail($user->getEmail());
            $buyer->setIdentityNumber("12312312312");
            $buyer->setRegistrationAddress($address->adress_content);
            $buyer->setCity($city);
            $buyer->setCountry($country);
            $request->setBuyer($buyer);

            $billingAddress = new \Iyzipay\Model\Address();
            $billingAddress->setContactName($user->getEmail());
            $billingAddress->setCity($city);
            $billingAddress->setCountry($country);
            $billingAddress->setAddress($address->adress_content);
            $request->setBillingAddress($billingAddress);

            $firstBasketItem = new \Iyzipay\Model\BasketItem();
            $firstBasketItem->setId($order->getId());
            $firstBasketItem->setName($adv->name);
            $firstBasketItem->setCategory1("VIRTUAL");
            $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::VIRTUAL);
            $firstBasketItem->setPrice($adv->price);
            $request->setBasketItems([$firstBasketItem]);

            $threedsInitialize = \Iyzipay\Model\ThreedsInitialize::create($request, $options);
            if ($threedsInitialize->getStatus() == "failure") {
                return back()->with('error', [$threedsInitialize->getErrorMessage()]);
            }
            $htmli = $threedsInitialize->getHtmlContent();
            return $this->view->make('visiosoft.module.payment_iyzico::iyzico/redirect', compact('htmli'));
        }
        abort(404);
    }

    public function paymentReturn()
    {
        $options = new \Iyzipay\Options();
        $options->setApiKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl(setting_value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));
        $pID = $this->request->paymentId;

        $request = new \Iyzipay\Request\CreateThreedsPaymentRequest();
        $request->setLocale(setting_value('streams::default_locale'));
        $request->setPaymentId($pID);
        $threedsPayment = \Iyzipay\Model\ThreedsPayment::create($request, $options);
        $order_id = $this->request->conversationId;

        if ($threedsPayment->getStatus() == 'success') {

            if ($order = $this->orderRepository->find($order_id) and $adv = $this->checkBuyable($this->request->cookie('fast-checkout-entry-id'))) {
                $order->setStatus('approved', $order->getId());
                $adv->updateStock($adv->getId(), 1);
                $this->messages->success(trans('visiosoft.module.carts::message.payment_approved'));
            } else {
                $this->messages->error(trans('visiosoft.extension.basic_checkout::field.order_message_confirmed_without_product', ['order_id' => $order_id]));
            }
        } else {
            $this->messages->error(trans('visiosoft.module.payment_iyzico::message.payment_failed'));
        }
        return Redirect::to(route('orders::purchase_detail', ['id' => $order_id]));
    }

    public function checkParamsRequest(array $required_params)
    {
        return !(\request()->has($required_params));
    }

    public function createOrder($item_id, $total, $bill_id, $delivery_id)
    {
        $order = $this->orderRepository->createOrder(Auth::id(), $total, $total, setting_value('streams::currency'), 'iyzico', $bill_id, $delivery_id);

        $this->orderdetailRepository->createDetail($item_id, 'adv', $total, setting_value('streams::currency'), $total, $order->getId(), 1, 'awaiting_payment');

        return $order;
    }

    public function checkBuyable($id)
    {
        return ($adv = $this->adv_model->isAdv($id) and $adv->stockControl($id, 1)) ? $adv : null;
    }

}
