<?php namespace Visiosoft\BasicCheckoutExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\UserRepository;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated;
use Visiosoft\PayingModule\Commands\Pay;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;

class BasicCheckoutController extends PublicController
{
    private $orderdetailRepository;
    private $orderRepository;
    private $adv_model;
    private $addressRepository;
    private $userRepository;

    public function __construct(
        AdvModel                       $advModel,
        OrderdetailRepositoryInterface $orderdetailRepository,
        AdressRepositoryInterface      $addressRepository,
        OrderRepositoryInterface       $orderRepository,
        UserRepository                 $userRepository)
    {
        parent::__construct();
        $this->adv_model = $advModel;
        $this->orderRepository = $orderRepository;
        $this->addressRepository = $addressRepository;
        $this->orderdetailRepository = $orderdetailRepository;
        $this->userRepository = $userRepository;
    }


    public function fast_checkout($id, $plan = null)
    {
        if (!Auth::check() && !setting_value('visiosoft.extension.basic_checkout::without_auth_payment_succesfull')) {
            return Redirect::to(url('/login'));
        }

        if ($adv = $this->checkBuyable($id, $plan)) {
            Cookie::queue(Cookie::make('fast-checkout-entry-id', $adv->getId(), 84000));
            return $this->view->make('visiosoft.extension.basic_checkout::checkout', compact('adv'));
        }
        return back()->with('error', [trans("visiosoft.extension.basic_checkout::message.error_stock")]);
    }

    public function payment($type = null)
    {
        if ($entry_id = $this->request->cookie('fast-checkout-entry-id') and $entry = $this->checkBuyable($entry_id, $type)) {
            if (!auth::check() && setting_value('visiosoft.extension.basic_checkout::without_auth_payment_succesfull') and !$type) {
                return $this->view->make('visiosoft.extension.basic_checkout::withoutAuthPaySuccess', compact('entry'));
            }

            $user = Auth::user();

            //Save Address
            $first_name = $this->request->adress_first_name;
            $last_name = $this->request->adress_last_name;
            $country_id = $this->request->country;
            $city_id = $this->request->city;
            $content = $this->request->adress_content;
            $gsm_phone = $this->request->adress_gsm_phone;

            $address = $this->addressRepository->createAddress('My Address', $user->getId(), $first_name, $last_name, $country_id, $city_id, $content, $gsm_phone);
            $country = $address->getCountry()->getTitle();
            $city = $address->getCity()->getTitle();

            //Create Order
            $order = $this->createOrder($entry->getId(), $entry->price, $address->getId(), $address->getId(), $type);

            $expiration = explode('/', $this->request->expiration);
            $cvv = $this->request->ccv;
            $card_holder_name = $this->request->name;
            $card_number = $this->request->ccno;

            if (setting_value("visiosoft.extension.basic_checkout::checkout_with_order")) {

                $message = trans('visiosoft.module.carts::message.payment_approved');

                $this->messages->success($message);

                return Redirect::to(url('purchase/detail/' . $order->getId()));

            } else {

                // Set Items
                $items = array();
                $item = [
                    'name' => $entry->name,
                    'quantity' => 1,
                    'price' => $entry->price
                ];

                $items[] = $item;

                // Start Payment
                $payment = new Pay();

                $pay = $payment->payByCard(str_replace(' ', '', $card_number), $card_holder_name, end($expiration), array_first($expiration), $cvv,
                    $order->total, $items, $order->currency, $order->id, $first_name, $last_name);

                if ($pay) {
                    $this->messages->success('visiosoft.module.orders::message.payment_successful');
                    $this->orderRepository->approveOrder($order->id);
                    return Redirect::to(route('orders::purchase_detail', ['id' => $order->id]));
                }

                $this->messages->error(trans('visiosoft.module.payment_iyzico::message.payment_failed'));
                return $this->redirect->to('/fast-checkout/' . $entry->getId() . '/plan');
            }
        }
        abort(404);
    }

    public function checkParamsRequest(array $required_params)
    {
        return !(\request()->has($required_params));
    }

    public function createOrder($item_id, $total, $bill_id, $delivery_id, $type = null)
    {
        $order = $this->orderRepository->createOrder(
            Auth::id(),
            $total,
            $total,
            setting_value('streams::currency'),
            setting_value("visiosoft.extension.basic_checkout::checkout_with_order") ? 'order' : 'iyzico',
            $bill_id,
            $delivery_id,
            $type);

        $this->orderdetailRepository->createDetail(
            $item_id,
            $type ?? 'adv',
            $total,
            setting_value('streams::currency'),
            $total,
            $order->getId(),
            1,
            setting_value("visiosoft.extension.basic_checkout::checkout_with_order") ? 'pending' : 'awaiting_payment');

        return $order;
    }

    public function checkBuyable($id, $plan = null)
    {
        if ($plan === 'plan' && is_module_installed('visiosoft.module.subscriptions')) {
            return app('Visiosoft\\SubscriptionsModule\\Plan\\Contract\\PlanRepositoryInterface')->find($id);
        }
        return ($adv = $this->adv_model->isAdv($id) and $adv->stockControl($id, 1)) ? $adv : null;
    }

}
