<?php namespace Visiosoft\BasicCheckoutExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\UserRepository;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\PaymentIyzicoModule\Events\IyziciPaymentCreated;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;

class BasicCheckoutController extends PublicController
{
    private $orderdetailRepository;
    private $orderRepository;
    private $adv_model;
    private $addressRepository;
    private $userRepository;

    public function __construct(
        AdvModel $advModel,
        OrderdetailRepositoryInterface $orderdetailRepository,
        AdressRepositoryInterface $addressRepository,
        OrderRepositoryInterface $orderRepository,
        UserRepository $userRepository)
    {
        parent::__construct();
        $this->adv_model = $advModel;
        $this->orderRepository = $orderRepository;
        $this->addressRepository = $addressRepository;
        $this->orderdetailRepository = $orderdetailRepository;
        $this->userRepository = $userRepository;
    }


    public function fast_checkout($id, $plan = null)
    {
        if ($adv = $this->checkBuyable($id, $plan)) {
            Cookie::queue(Cookie::make('fast-checkout-entry-id', $adv->getId(), 84000));
            return $this->view->make('visiosoft.extension.basic_checkout::checkout', compact('adv'));
        }
        abort(404);
    }

    public function payment($type = null)
    {
        if ($entry_id = $this->request->cookie('fast-checkout-entry-id') and $adv = $this->checkBuyable($entry_id, $type)) {

            $user = Auth::user();

            //Save Address
            $first_name = $this->request->adress_first_name;
            $last_name = $this->request->adress_last_name;
            $country_id = $this->request->country;
            $city_id = $this->request->city;
            $content = $this->request->adress_content;
            $gsm_phone = $this->request->adress_gsm_phone;

            $address = $this->addressRepository->createAddress('My Address', $user->getId(), $first_name, $last_name, $country_id, $city_id, $content, $gsm_phone);
            $country = $address->getCountry()->getTitle();
            $city = $address->getCity()->getTitle();

            //Create Order
            $order = $this->createOrder($adv->getId(), $adv->price, $address->getId(), $address->getId(), $type);

            $expiration = explode('/', $this->request->expiration);

            $options = new \Iyzipay\Options();
            $options->setApiKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
            $options->setSecretKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
            $options->setBaseUrl(setting_value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));

            $request = new \Iyzipay\Request\CreatePaymentRequest();
            $request->setLocale(setting_value('streams::default_locale'));
            $request->setPrice($adv->price);

            $conversation_parameters = [
                'order_id' => $order->getId(),
                'payment_status' => null,
            ];

            if (Auth::check()) {
                //Remember Auth
                $auth = $this->userRepository->find(Auth::id());
                $remember_token_code = Str::random(20);
                $auth->setAttribute('remember_token', $remember_token_code);
                $auth->save();
                $conversation_parameters['remember_token'] = $remember_token_code;
            }

            $request->setConversationId(str_replace('"', '\'', json_encode($conversation_parameters)));
            $request->setPaidPrice($adv->price);
            $request->setCurrency(setting_value('streams::currency'));
            $request->setInstallment(1);
            $request->setCallbackUrl(route('visiosoft.extension.basic_checkout::fast-checkout.result'));

            $paymentCard = new \Iyzipay\Model\PaymentCard();
            $paymentCard->setCardHolderName($this->request->name);
            $paymentCard->setCardNumber(str_replace(' ', '', $this->request->ccno));
            $paymentCard->setExpireMonth(array_first($expiration));
            $paymentCard->setExpireYear(end($expiration));
            $paymentCard->setCvc($this->request->ccv);
            $paymentCard->setRegisterCard(0);
            $request->setPaymentCard($paymentCard);

            $buyer = new \Iyzipay\Model\Buyer();
            $buyer->setId(Auth::id());
            $buyer->setName($address->adress_first_name);
            $buyer->setSurname($address->adress_last_name);
            $buyer->setEmail($user->getEmail());
            $buyer->setIdentityNumber("12312312312");
            $buyer->setRegistrationAddress($address->adress_content);
            $buyer->setCity($city);
            $buyer->setCountry($country);
            $request->setBuyer($buyer);

            $billingAddress = new \Iyzipay\Model\Address();
            $billingAddress->setContactName($user->getEmail());
            $billingAddress->setCity($city);
            $billingAddress->setCountry($country);
            $billingAddress->setAddress($address->adress_content);
            $request->setBillingAddress($billingAddress);

            $firstBasketItem = new \Iyzipay\Model\BasketItem();
            $firstBasketItem->setId($order->getId());
            $firstBasketItem->setName($adv->name);
            $firstBasketItem->setCategory1("VIRTUAL");
            $firstBasketItem->setItemType(\Iyzipay\Model\BasketItemType::VIRTUAL);
            $firstBasketItem->setPrice($adv->price);
            $request->setBasketItems([$firstBasketItem]);

            $threedsInitialize = \Iyzipay\Model\ThreedsInitialize::create($request, $options);
            if ($threedsInitialize->getStatus() == "failure") {
                return back()->with('error', [$threedsInitialize->getErrorMessage()]);
            }
            $htmli = $threedsInitialize->getHtmlContent();
            return $this->view->make('visiosoft.module.payment_iyzico::iyzico/redirect', compact('htmli'));
        }
        abort(404);
    }

    public function paymentReturn()
    {
        $conversation_parameters = $this->request->get('conversationId');
        $conversation_parameters = json_decode(str_replace('\'','"',$conversation_parameters),true);
        $order_id = $conversation_parameters['order_id'];

        $options = new \Iyzipay\Options();
        $options->setApiKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setApiKey'));
        $options->setSecretKey(setting_value('visiosoft.module.payment_iyzico::iyzico_setSecretKey'));
        $options->setBaseUrl(setting_value('visiosoft.module.payment_iyzico::iyzico_setBaseUrl'));
        $pID = $this->request->paymentId;

        if (isset($conversation_parameters['remember_token']) and !empty($conversation_parameters['remember_token'])
            and $auth = $this->userRepository->findBy('remember_token', $conversation_parameters['remember_token'])) {

            $last_activity = strtotime($auth->last_activity_at);
            $now = time();

            //diff 3 minutes
            if (($now - $last_activity) < 180) {
                Auth::login($auth);
            }

            //remove remember token
            $auth->setAttribute('remember_token', null);
            $auth->save();
        }

        $request = new \Iyzipay\Request\CreateThreedsPaymentRequest();
        $request->setLocale(setting_value('streams::default_locale'));
        $request->setPaymentId($pID);
        $threedsPayment = \Iyzipay\Model\ThreedsPayment::create($request, $options);

        if ($threedsPayment->getStatus() == 'success') {
            if ($order = $this->orderRepository->find($order_id) and $adv = $this->checkBuyable($this->request->cookie('fast-checkout-entry-id'))) {
                $order->setStatus('approved', $order->getId());
                $adv->updateStock($adv->getId(), 1);
                $this->messages->success(trans('visiosoft.module.carts::message.payment_approved'));
            } else {

                event(new IyziciPaymentCreated($threedsPayment));
                $this->orderRepository->approveOrder($order_id);

                if (!$order = $this->orderRepository->newQuery()->find($order_id)) {
                    $this->messages->error(trans('visiosoft.module.payment_iyzico::message.error_approving'));
                    return $this->redirect->to('/purchase');
                }
                if (isset($conversation_parameters['payment_status'])){
                    return $this->view->make($conversation_parameters['payment_status']);
                }

                return Redirect::to(route('orders::purchase_detail', ['id' => $order_id]));
            }
        } else {
            $this->messages->error(trans('visiosoft.module.payment_iyzico::message.payment_failed'));
        }
        return redirect('payment/success/iyzico');
    }

    public function checkParamsRequest(array $required_params)
    {
        return !(\request()->has($required_params));
    }

    public function createOrder($item_id, $total, $bill_id, $delivery_id, $type = null)
    {
        $order = $this->orderRepository->createOrder(Auth::id(), $total, $total, setting_value('streams::currency'), 'iyzico', $bill_id, $delivery_id, $type);

        $this->orderdetailRepository->createDetail($item_id, $type ?? 'adv', $total, setting_value('streams::currency'), $total, $order->getId(), 1, 'awaiting_payment');

        return $order;
    }

    public function checkBuyable($id, $plan = null)
    {
        if ($plan === 'plan' && is_module_installed('visiosoft.module.subscriptions')) {
            return app('Visiosoft\\SubscriptionsModule\\Plan\\Contract\\PlanRepositoryInterface')->find($id);
        }
        return ($adv = $this->adv_model->isAdv($id) and $adv->stockControl($id, 1)) ? $adv : null;
    }

}
