<?php namespace Visiosoft\BarberlinTheme;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;


class BarberlinThemeServiceProvider extends AddonServiceProvider
{
    /**
     * The view overrides.
     *
     * @var array
     */
    protected $overrides = [
        'streams::errors/404' => 'theme::errors/404',
        'streams::errors/500' => 'theme::errors/500',
    ];

    public function boot(AddonCollection $addonCollection)
    {
        $slug = 'news_settings';
        $section = [
            'title'   => 'Visiosoft Settings',
            'href'    => '/admin/settings/themes/visiosoft.theme.barberlin',
        ];
        $addonCollection->get('anomaly.module.settings')->addSection($slug, $section);
    }


}
