<?php namespace Visiosoft\Barber2Theme;

use Illuminate\Routing\Router;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;

class Barber2ThemeServiceProvider extends AddonServiceProvider
{

    protected $overrides = [
        'streams::errors/404' => 'theme::errors/404',
        'streams::errors/500' => 'theme::errors/500',
    ];

    public function boot()
    {
        view()->composer('*', function () {
            $hide = ['export', 'assets_clear', 'system', 'modules', 'themes', 'extensions', 'field_types', 'plugins', 'general_settings'];

            foreach ($hide as $item) {
                if (auth()->user() && !auth()->user()->hasRole("admin") && template()->get('cp') && $section = template()->get('cp')->getSections()->get($item)) {
                    $section->setClass('hidden');
                }
            }
        });
    }

    public function getOverrides()
    {
        $booking_only = config('theme::booking_only', false);

        if ($booking_only) {
            $request = app('Illuminate\Http\Request');

            if ($request->segment(1) != null && $request->segment(1) != "admin" && ($request->segment(1) != "booking" && $request->segment(2) != "detail")) {
                return [
                    'visiosoft.theme.barber2::layouts.page' => 'visiosoft.theme.barber2::errors/404',
                    'visiosoft.theme.barber2::layouts.default' => 'visiosoft.theme.barber2::errors/404',
                    'visiosoft.theme.barber2::layouts.login' => 'visiosoft.theme.barber2::errors/404',
                    'visiosoft.theme.barber2::layouts.booking' => 'visiosoft.theme.barber2::errors/404',
                ];
            }

        }

        return parent::getOverrides();
    }

    public function map(Router $router)
    {
        $booking_only = config('theme::booking_only', false);

        if($booking_only){
            $router->get('/', [
                "uses" => "Visiosoft\BookingModule\Http\Controller\BookingController@index",
                "streams::addon" => "anomaly.module.pages",
                "anomaly.module.pages::page" => 1,
                "controller" => "Anomaly\PagesModule\Http\Controller\PagesController@view"
            ]);
        }
    }
}
