<?php namespace Visiosoft\Barber2Theme;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterHomeButtonsEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class Barber2ThemeSeeder extends Seeder
{
    private $streamRepository;
    private $fieldRepository;
    private $assignmentRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository
    )
    {
        parent::__construct();
        $this->streamRepository = $streamRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    public function run()
    {
        // Create repeaters
        $repeaters = [
            [
                'name' => 'Home Buttons',
                'slug' => 'home_buttons',
                'translatable' => false,
                'fields' => ['button_text', 'button_url','button_background']
            ],
        ];

        $repeatersObjects = array();
        foreach ($repeaters as $repeater) {
            $exists = $this->streamRepository->findBySlugAndNamespace($repeater['slug'], 'repeater');
            $repeatersObjects[$repeater['slug']] = $exists ?: $this->streamRepository->create([
                'name' => $repeater['name'],
                'namespace' => 'repeater',
                'slug' => $repeater['slug'],
                'prefix' => 'repeater_',
                'translatable' => $repeater['translatable'],
            ]);
        }

        // Assign repeater fields
        $repeatersFields = [
            [
                'name' => 'Button Text',
                'namespace' => 'repeater',
                'slug' => 'button_text',
                'type' => 'anomaly.field_type.text',
                "assignmentConfig" => [
                    "required" => true,
                ],
            ],
            [
                'name' => 'Button URL',
                'namespace' => 'repeater',
                'slug' => 'button_url',
                'type' => 'anomaly.field_type.text',
                "assignmentConfig" => [
                    "required" => true,
                ],
            ],
            [
                'name' => 'Button Background',
                'namespace' => 'repeater',
                'slug' => 'button_background',
                'type' => 'anomaly.field_type.colorpicker',
                "assignmentConfig" => [
                    "required" => true,
                ],
            ],
        ];

        foreach ($repeatersFields as $repeatersField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($repeatersField['slug'], 'repeater');
            if (!$field) {
                $fieldValue = [
                    'name' => $repeatersField['name'],
                    'namespace' => 'repeater',
                    'slug' => $repeatersField['slug'],
                    'type' => $repeatersField['type'],
                    'locked' => 0,
                ];
                $field = $this->fieldRepository->create($fieldValue);
            }
            foreach ($repeaters as $repeater) {
                if (in_array($field->slug, $repeater['fields'])) {
                    $assign = $this->assignmentRepository->findByStreamAndField(
                        $repeatersObjects[$repeater['slug']],
                        $field
                    );
                    if (!$assign) {
                        $this->assignmentRepository->create(array_merge([
                            'stream_id' => $repeatersObjects[$repeater['slug']]->getId(),
                            'field_id' => $field->id,
                            'label' => $field->name,
                        ], $repeatersField['assignmentConfig']));
                    }
                }
            }
        }

        // Assign pages fields
        $defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');

        $pagesFields = [
            [
                'name' => 'Home Buttons',
                'slug' => 'home_buttons',
                "config" => [
                    "related" => RepeaterHomeButtonsEntryModel::class,
                    "max" => 3,
                ]
            ]
        ];

        foreach ($pagesFields as $pagesField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($pagesField['slug'], 'pages');
            if (!$field) {
                $field = $this->fieldRepository->create([
                    'name' => $pagesField['name'],
                    'namespace' => 'pages',
                    'slug' => $pagesField['slug'],
                    'type' => 'anomaly.field_type.repeater',
                    'locked' => 0,
                    "config" => $pagesField['config']
                ]);
            }
            $assign = $this->assignmentRepository->findByStreamAndField($defaultPagesStream, $field);
            if (!$assign) {
                $this->assignmentRepository->create([
                    'stream_id' => $defaultPagesStream->getId(),
                    'field_id' => $field->id,
                    'label' => $pagesField['name'],
                ]);
            }
        }
    }

}
