<?php namespace Visiosoft\Barber2Theme;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;

class Barber2ThemeServiceProvider extends AddonServiceProvider
{

    protected $overrides = [
        'streams::errors/404' => 'theme::errors/404',
        'streams::errors/500' => 'theme::errors/500',
    ];

    public function boot()
    {
        view()->composer('*', function () {
            $hide = ['export', 'assets_clear', 'system', 'modules', 'themes', 'extensions', 'field_types', 'plugins', 'general_settings'];

            foreach ($hide as $item) {
                if (auth()->user() && !auth()->user()->hasRole("admin") && $section = template()->get('cp')->getSections()->get($item)) {
                    $section->setClass('hidden');
                }
            }
        });
    }

}
