<?php namespace Visiosoft\BankidModule\Bankid;
use Dimafe6\BankID\Service\BankIDService;

class BankidApiCollection
{
    /**
     * @var BankIDService $bankIDService
     */
    private $bankIDService;

    public function __construct()
    {

        $this->bankIDService = new BankIDService(
            setting_value('visiosoft.module.bankid::api_url'),
            isset($_SERVER["REMOTE_ADDR"]) ? $_SERVER["REMOTE_ADDR"] : '127.0.0.1',
            [
                'verify' => false,
                'cert' => [''.__DIR__.'/ssl/drifterworld.p12',setting_value('visiosoft.module.bankid::ssl_password')],
            ]
        );
    }

    public function sign($ssn)
    {
        $signResponse = $this->bankIDService->getSignResponse(
            $ssn,
            'userVisibleData',
            'userNonVisibleData'
        );

        return $signResponse;
    }

    public function checkSign($token)
    {
        $collectResponse = $this->bankIDService->collectResponse($token);
        return $collectResponse;
    }

    public function createAccessToken($ssn){
        $authResponse = $this->bankIDService->getAuthResponse($ssn);
        return $authResponse;
    }

    public function checkAccessToken($token){
        $authResponse = $this->bankIDService->collectResponse($token);
        return $authResponse;
    }


    public function show()
    {
        $resp = $this->checkSign($this->sign());
        return [$resp->orderRef, $resp->status, $resp->hintCode];
    }

}