<?php namespace Visiosoft\BankidModule\Http\Controller\Api;

namespace Visiosoft\BankidModule\Http\Controller\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Validator;
use Visiosoft\BankidModule\Bankid\BankID;
use Visiosoft\ConnectModule\Http\Controller\ApiBaseController;

class ApiController extends ApiBaseController
{
    private $bankID;

    public function __construct()
    {
        $this->bankID = new BankID();
    }

    public function index($token)
    {
        $status = $this->bankID->checkSign($token);
        if (!$status) {
            return $this->sendResponse(['status' => Cache::get($token)]);
        }

        Cache::put($token, $status);
        return $this->sendResponse(['status' => $status]);
    }

    public function store()
    {
        $request = request()->all();
        //TODO::Change with a central function
        $validator = Validator::make($request, [
            'ssn' => 'required|string|min:12|max:12',
            'request_content' => 'required|string',
            'request_name' => 'string|max:255',
        ]);

        if ($validator->fails()) {
            return $this->sendError($validator->errors(), '', 422);
        }

        $requestSsn = $request['ssn'];
        $requestName = $request['request_name'] ?? '';
        $requestSlug = str_slug($requestName, '_');
        $requestContent = $request['request_content'];
        $signRequest = $this->bankID->sign($requestSsn, $requestSlug, $requestName, $requestContent);

        //Response Example: "5f2a4ad6-1c52-47de-bf6e-fa5c8582209a"
        return $this->sendResponse(['token' => $signRequest]);
    }
}