<?php namespace Visiosoft\BankidModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Support\Facades\Route;
use Visiosoft\BankidModule\Command\CheckRequestStatus;
use Visiosoft\BankidModule\SignRequest\Contract\SignRequestRepositoryInterface;
use Visiosoft\BankidModule\SignRequest\SignRequestRepository;
use Anomaly\Streams\Platform\Model\Bankid\BankidSignRequestsEntryModel;
use Visiosoft\BankidModule\SignRequest\SignRequestModel;
use Anomaly\UsersModule\User\Event\PhotoUploaded;
use Illuminate\Routing\Router;
use Visiosoft\BankidModule\Listener\PhotoUploadedListener;

class BankidModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [
        CheckRequestStatus::class
    ];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [
        '* * * * *' => [
            CheckRequestStatus::class
        ]
    ];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/bankid'           => 'Visiosoft\BankidModule\Http\Controller\Admin\SignRequestsController@index',
        'admin/bankid/create'    => 'Visiosoft\BankidModule\Http\Controller\Admin\SignRequestsController@create',
        'admin/bankid/edit/{id}' => 'Visiosoft\BankidModule\Http\Controller\Admin\SignRequestsController@edit',
        'api/bankid/show' => 'Visiosoft\BankidModule\Bankid\BankidApiCollection@show',
        'bankid' => 'Visiosoft\BankidModule\Http\Controller\BankidController@index',
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        PhotoUploaded::class => [
            PhotoUploadedListener::class,
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BankidSignRequestsEntryModel::class => SignRequestModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SignRequestRepositoryInterface::class => SignRequestRepository::class,
    ];


    /**
     * Map additional addon routes.
     */
    public function map()
    {
        Route::group(['prefix' => 'api/v2', 'middleware' => 'auth:api'], function () {
            Route::post('/bankid/sign-requests', 'Visiosoft\BankidModule\Http\Controller\Api\ApiController@store');
            Route::get('/bankid/sign-requests/{id}', 'Visiosoft\BankidModule\Http\Controller\Api\ApiController@index');
        });
    }

}
