<?php namespace Visiosoft\BankidModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BankidModule\Command\CheckRequestStatus;
use Visiosoft\BankidModule\SignRequest\Contract\SignRequestRepositoryInterface;
use Visiosoft\BankidModule\SignRequest\SignRequestRepository;
use Anomaly\Streams\Platform\Model\Bankid\BankidSignRequestsEntryModel;
use Visiosoft\BankidModule\SignRequest\SignRequestModel;
use Anomaly\UsersModule\User\Event\PhotoUploaded;
use Illuminate\Routing\Router;
use Visiosoft\BankidModule\Listener\PhotoUploadedListener;

class BankidModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [
        CheckRequestStatus::class
    ];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [
        '* * * * *' => [
            CheckRequestStatus::class
        ]
    ];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/bankid'           => 'Visiosoft\BankidModule\Http\Controller\Admin\SignRequestsController@index',
        'admin/bankid/create'    => 'Visiosoft\BankidModule\Http\Controller\Admin\SignRequestsController@create',
        'admin/bankid/edit/{id}' => 'Visiosoft\BankidModule\Http\Controller\Admin\SignRequestsController@edit',
        'api/bankid/show' => 'Visiosoft\BankidModule\Bankid\BankidApiCollection@show',
        'bankid' => 'Visiosoft\BankidModule\Http\Controller\BankidController@index',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BankidModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BankidModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        PhotoUploaded::class => [
            PhotoUploadedListener::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BankidModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BankidSignRequestsEntryModel::class => SignRequestModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SignRequestRepositoryInterface::class => SignRequestRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {

        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
