<?php namespace Visiosoft\BankidModule\SignRequest;

use Visiosoft\BankidModule\SignRequest\Contract\SignRequestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SignRequestRepository extends EntryRepository implements SignRequestRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SignRequestModel
     */
    protected $model;

    /**
     * Create a new SignRequestRepository instance.
     *
     * @param SignRequestModel $model
     */
    public function __construct(SignRequestModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param string $ssn
     * @param string $orderRef
     * @param string $orderSlug
     * @param string $orderName
     * @param string $orderContent
     */
    public function createOrder(string $ssn, string $orderRef, string $orderSlug, string $orderName, string $orderContent)
    {
        return $this->model->create([
            'ssn' => $ssn,
            'order_ref' => $orderRef,
            'order_slug' => $orderSlug,
            'order_name' => $orderName,
            'order_content' => $orderContent
        ]);
    }

    public function getPendingRequest()
    {
        return $this->model->where('status', 'pending')->get();
    }
}
