<?php namespace Visiosoft\BankidModule\Command;

use Illuminate\Console\Command;
use Visiosoft\BankidModule\Bankid\BankID;
use Visiosoft\BankidModule\SignRequest\Contract\SignRequestRepositoryInterface;

class CheckRequestStatus extends Command
{
    protected $signature = 'bankid:check_request_status';

    protected $description = 'check request statuses';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $signRequestRepository = app(SignRequestRepositoryInterface::class);
        $bankID = app(BankID::class);
        $requests = $signRequestRepository->getPendingRequest();
        foreach ($requests as $request) {
            $bankID->checkSign($request->order_ref);
        }

    }
}
