<?php namespace Visiosoft\BankidModule\SignRequest;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BankidModule\Bankid\BankID;
use Visiosoft\BankidModule\Command\CheckRequestStatus;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;

class SignRequestApiCollection extends SignRequestRepository
{
    use DispatchesJobs;

    public function checkSign(array $params)
    {
        $this->dispatch(new CheckRequiredParams(['ssn', 'request_type'], $params));
        $bankID = app(BankID::class);

        $request = $this->getRequestBySsn($params['ssn'], $params['request_type']);
        $bankID->checkSign($request->order_ref);

        if (!$request) {
            throw new \Exception(trans('visiosoft.module.bankid::message.an_error_occured'));
        }

        return $request->status;


    }
}