<?php

namespace Visiosoft\BankidModule\Listener;

use Anomaly\UsersModule\User\Event\PhotoUploaded;
use Visiosoft\BankidModule\Bankid\BankID;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class PhotoUploadedListener extends BankID
{
    public function handle(PhotoUploaded $event)
    {
        $type = $event->getType();
        $templateRepository = app(TemplateRepositoryInterface::class);
        try {
            $content = "";
            switch ($type['slug']){
                case "disabled_card_photo":
                    $template = $templateRepository->findBy('slug', 'bankid_disabled_card');
                    $content = strip_tags($template->message);
                break;
                default:
                    $content = $type['name'];
            }

            $this->sign($event->getSSN(), $type['slug'], $type['name'], $content);
        }catch (\Exception $e){
            $this->logError($e);
        }
    }

}