<?php namespace Visiosoft\BankidModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class BankidModuleSeeder extends Seeder
{

    public $templates = [
        'bankid_disabled_card' => [
            'slug' => 'bankid_disabled_card',
            'en' => [
                'name' => "Drifter's Digital Disable Parking Card - General Conditions",
                'subject' => "Drifter's Digital Disable Parking Card - General Conditions",
                'greeting' => "Drifter's Digital Disable Parking Card - General Conditions",
                'message' => "Drifter's Digital Disable Parking Card - General Conditions
                    When you accept this, you commit to the following conditions:
                    All the information you entered is correct, and you undertake that you will cancel or change your card if this information changes.
                    When you downloaded the application, you agreed to the general conditions for parking in our parking lots. These conditions regulate, among other things, what is meant by dynamic taxi and incorrect parking. These conditions also apply to you with a parking permit. You will find these conditions here:
                    https://drifterworld.se/terms-and-conditions/"
            ],
            'sv' => [
                'name' => "Drifter's Digital Disable Parking Card - Allmänna villkor",
                'subject' => "Drifter's Digital Disable Parking Card - Allmänna villkor",
                'greeting' => "Drifter's Digital Disable Parking Card - Allmänna villkor",
                'message' => "När du accepterar detta förbinder du dig till följande villkor:
                    All information du angett är korrekt och du förbinder dig att avbryta eller ändra ditt kort om denna information ändras.
                    När du laddade ner applikationen godkände du de allmänna villkoren för parkering på våra parkeringsplatser. Dessa villkor reglerar bland annat vad som avses med dynamisk taxa och felaktig parkering. Dessa villkor gäller också för dig som har ett parkeringstillstånd. Du hittar dessa villkor här:
                    https://drifterworld.se/terms-and-conditions/"
            ]
        ]
    ];
    public function run()
    {
        foreach ($this->templates as $key => $template) {
            $templateRepository = app(TemplateRepositoryInterface::class);

            if (!$templateRepository->findBy('slug', $key)) {
                $template['enabled'] = true;
                $template['stream'] = null;
                $template['view'] = null;
                $templateRepository->newQuery()->create($template);
                $this->command->info($key . ' notification template created...');
            }
        }
    }
}
