<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBankidCreateSignRequestsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'sign_requests',
        'title_column' => 'ssn',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'ssn',
        'order_slug',
        'order_name',
        'order_content',
        'order_ref',
        'status',
        'sign_date'
    ];


    protected $fields = [
        'ssn' => "anomaly.field_type.text",
        'order_slug' => "anomaly.field_type.text",
        'order_name' => "anomaly.field_type.text",
        'order_content' => "anomaly.field_type.textarea",
        'order_ref' => "anomaly.field_type.text",
        'status' => [
            'type' => "anomaly.field_type.text",
            'config' => [
                'default_value' => "pending"
            ]
        ],
        'sign_date' => "anomaly.field_type.text"
    ];
}
