<?php

namespace Visiosoft\BankidModule\Listener;

use Anomaly\UsersModule\User\Event\PhotoUploaded;
use Visiosoft\BankidModule\Bankid\BankID;

class PhotoUploadedListener extends BankID
{
    public function handle(PhotoUploaded $event)
    {
        $type = $event->getType();
        try {
            $this->sign($event->getSSN(), $type['slug'], $type['name'], $type['name']);
        }catch (\Exception $e){
            $this->logError($e);
        }
    }

}